function cpp_stress(sMap,cnames,fc)

% Component plane presentation of the codebook matrix in such manner that each time course 
% lies horizontally

% fc denotes the symmetric color limits to specified maximum values
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% for proper visualization later, convert cname to tempcnames
tempcnames=cnames;
for i=1:length(cnames)
    tempcnames{i}=strrep(cnames{i},'_','\_');% replace '-' with '\_'
end

% Component plane presentation of trained SOM
scrsz = get(0,'ScreenSize');
figure('Position',[scrsz(3)*1/20 scrsz(3)*1/20 scrsz(3)*7/10*(0.815/0.775) scrsz(3)*7/10])
set(gcf,'paperpositionmode','auto','color','w')

tmp_fontsize=6;
index_stress=[8 15 22 31 40 51 59 67 76];
for i=1:size(sMap.codebook,2)
    switch i;
        case num2cell(1:8);
            subplot(9,11,i);h=som_cplane(sMap,sMap.codebook(:,i));
            set(h,'edgecolor','none');caxis([-fc fc]);
            set(gca,'Fontsize',tmp_fontsize);title(tempcnames{i},'Color','b');
        case num2cell(9:15);
            subplot(9,11,i-9+1+11*1);h=som_cplane(sMap,sMap.codebook(:,i));
            set(h,'edgecolor','none');caxis([-fc fc]);
            set(gca,'Fontsize',tmp_fontsize);title(tempcnames{i},'Color','b');   
        case num2cell(16:22);
            subplot(9,11,i-16+1+11*2);h=som_cplane(sMap,sMap.codebook(:,i));
            set(h,'edgecolor','none');caxis([-fc fc]);
            set(gca,'Fontsize',tmp_fontsize);title(tempcnames{i},'Color','b');  
        case num2cell(23:31);
            subplot(9,11,i-23+1+11*3);h=som_cplane(sMap,sMap.codebook(:,i));
            set(h,'edgecolor','none');caxis([-fc fc]);
            set(gca,'Fontsize',tmp_fontsize);title(tempcnames{i},'Color','b'); 
        case num2cell(32:40);
            subplot(9,11,i-32+1+11*4);h=som_cplane(sMap,sMap.codebook(:,i));
            set(h,'edgecolor','none');caxis([-fc fc]);
            set(gca,'Fontsize',tmp_fontsize);title(tempcnames{i},'Color','b'); 
        case num2cell(41:51);
            subplot(9,11,i-41+1+11*5);h=som_cplane(sMap,sMap.codebook(:,i));
            set(h,'edgecolor','none');caxis([-fc fc]);
            set(gca,'Fontsize',tmp_fontsize);title(tempcnames{i},'Color','b'); 
        case num2cell(52:59);
            subplot(9,11,i-52+1+11*6);h=som_cplane(sMap,sMap.codebook(:,i));
            set(h,'edgecolor','none');caxis([-fc fc]);
            set(gca,'Fontsize',tmp_fontsize);title(tempcnames{i},'Color','b'); 
        case num2cell(60:67);
            subplot(9,11,i-60+1+11*7);h=som_cplane(sMap,sMap.codebook(:,i));
            set(h,'edgecolor','none');caxis([-fc fc]);
            set(gca,'Fontsize',tmp_fontsize);title(tempcnames{i},'Color','b');  
        case num2cell(68:76);
            subplot(9,11,i-68+1+11*8);h=som_cplane(sMap,sMap.codebook(:,i));
            set(h,'edgecolor','none');caxis([-fc fc]);
            set(gca,'Fontsize',tmp_fontsize);title(tempcnames{i},'Color','b');  
    end
end

return
